<?php
/**
 * @package web-result
 * @since 1.0.0
 */
?>

<meta http-equiv="refresh" content="3">

<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/livedraw-blue.css">

<div class="web-singapore">
    <div class="card card-livedraw shadow border-none p-1 ml-auto mr-auto my-2">
        <div class="card-header bg-white px-1 pt-1 pb-0">
            <div class="card-title-box p-1">
                <div class="row m-0">
                    <div class="col-auto p-0">
                        <div class="title-logo text-center text-uppercase">4D</div>
                    </div>
                    <div class="col p-0">
                        <div class="title-text text-center text-uppercase">Singapore Night</div>
                    </div>
                </div>
            </div>
            <div class="row justify-content-around align-items-center m-0">
                <div class="col-12 px-0">
                    <table class="table table-sm table-bordered text-center mb-0">
                        <tr>
                            <td><span>Live Draw : <?php echo $web_data['tanggal']; ?></span></td>
                            <td><span id="jam"><?php echo date('H:i:s A'); ?></span></td>
                        </tr>
                        <tr>
                            <td class="p-0" colspan="2">
                                <div class="text-center text-small text-blink p-1"><?php echo $text_ads; ?></div>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="col-12 px-0 text-center">
                    <p class="bg-blue text-white text-uppercase font-weight-bold py-1 mb-0">4D Draw</p>
                </div>
            </div>
        </div>
        
        <div class="card-body bg-white px-1 pb-1 pt-0">
            <div class="table-responsive">
                <table class="table table-sm table-bordered text-center border-dark m-0">
                    <tbody>
                        <tr>
                            <td width="50%" class="border-dark bg-blue">
                                <h5 class="text-winner text-white text-center text-uppercase font-weight-bold m-0">Result</h5>
                            </td>
                            <td width="50%" class="border-dark">
                                <h5 class="result-winner text-blue font-weight-bold m-0"><?php echo $web_data['prize_1']; ?></h5>
                            </td>
                        </tr>
                        <tr>
                            <td width="50%" class="border-dark bg-blue text-white text-uppercase">
                                <h5 class="text-white text-center text-uppercase font-weight-bold m-0">Prize 2</h5>
                            </td>
                            <td width="50%" class="border-dark">
                                <h5 class="result-sub-winner text-dark font-weight-bold m-0"><?php echo $web_data['prize_2']; ?></h5>
                            </td>
                        </tr>
                        <tr>
                            <td width="50%" class="border-dark bg-blue text-white text-uppercase">
                                <h5 class="text-white text-center text-uppercase font-weight-bold m-0">Prize 3</h5>
                            </td>
                            <td width="50%" class="border-dark">
                                <h5 class="result-sub-winner text-dark font-weight-bold m-0"><?php echo $web_data['prize_3']; ?></h5>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="row justify-content-around align-items-center mx-0">
                <div class="col-12 px-0 text-center">
                    <div class="bg-blue text-white text-uppercase py-1">
                        <p class="m-0">Starter Prize</p>
                    </div>
                </div>
                <div class="col-12 px-0 text-center">
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered text-center m-0">
                            <tbody>
                                <?php if (array_key_exists('prize_4', $web_data) && $web_data['prize_4'] != null) : ?>
                                    <tr>
                                        <?php foreach ($web_data['prize_4'] as $prize_4) : ?>
                                            <td class="text-dark p-0"><span><?php echo $prize_4; ?></span></td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endif; ?>

                                <?php if (array_key_exists('prize_5', $web_data) && $web_data['prize_5'] != null) : ?>
                                    <tr>
                                        <?php foreach ($web_data['prize_5'] as $prize_5) : ?>
                                            <td class="text-dark p-0"><span><?php echo $prize_5; ?></span></td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="row justify-content-around align-items-center mx-0">
                <div class="col-12 px-0 text-center">
                    <div class="bg-blue text-white text-uppercase py-1">
                        <p class="m-0">Consolation Prize</p>
                    </div>
                </div>
                <div class="col-12 px-0 text-center">
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered text-center m-0">
                            <tbody>
                                <?php if (array_key_exists('prize_6', $web_data) && $web_data['prize_6'] != null) : ?>
                                    <tr>
                                        <?php foreach ($web_data['prize_6'] as $prize_6) : ?>
                                            <td class="text-dark p-0"><span><?php echo $prize_6; ?></span></td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endif; ?>

                                <?php if (array_key_exists('prize_7', $web_data) && $web_data['prize_7'] != null) : ?>
                                    <tr>
                                        <?php foreach ($web_data['prize_7'] as $prize_7) : ?>
                                            <td class="text-dark p-0"><span><?php echo $prize_7; ?></span></td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
