<?php
/**
 * @package web-result
 * @since 1.0.0
 */
$pasaran_name = ( isset( $_GET['pasaran'] ) ? $_GET['pasaran'] : 'hongkong' );
$pasaran_text = strtoupper( str_replace( '-', ' ', $pasaran_name ) );
?>

<meta http-equiv="refresh" content="3">

<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/livedraw-dark.css">

<div class="card card-result ml-auto mr-auto my-2">
    <div class="card-body bg-black p-2">
        <div class="row justify-content-center align-items-stretch m-0">
            <div class="col-12 p-0">
                <h5 class="text-white text-center text-uppercase bg-custom mb-0 p-2">
                    <span class="font-weight-bold text-gold"><?php echo $pasaran_text; ?></span>
                </h5>
            </div>
            <div class="col-12 p-0">
                <table class="table table-sm table-bordered my-0">
                    <tbody>
                        <tr>
                            <td class="text-white text-center text-small m-0">Live Draw : <?php echo $web_data['tanggal']; ?></td>
                            <td class="text-white text-center text-small m-0" id="jam"><?php echo date('H:i:s A'); ?></td>
                        </tr>
                        <tr>
                            <td class="text-white text-center m-0 p-0" colspan="2">
                                <div class="text-small text-blink text-gold p-1"><?php echo $text_ads; ?></div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-12 p-0">
                <table class="table table-sm table-bordered text-center m-0">
                    <tbody>
                        <tr>
                            <td class="bg-custom p-0 text-center">
                                <h5 class="font-weight-bolder py-2 m-0">1st Prize</h5>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="table table-sm table-bordered text-center m-0">
                    <tbody>
                        <tr>
                            <?php if ( is_numeric($web_data['prize_1']) ) : ?>
                                <?php foreach ( str_split($web_data['prize_1']) as $prize1 ) : ?>
                                    <td class="bg-black p-0" style="font-size:32px;color:skyblue;">
                                        <span class="font-weight-bolder"><?php echo $prize1; ?></span>
                                    </td>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <td class="bg-black p-0" style="font-size:32px;color:skyblue;">
                                    <span class="font-weight-bolder"><?php echo $web_data['prize_1']; ?></span>
                                </td>
                            <?php endif; ?>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
