<?php
/**
 * Template Name: RTP Slot
 * Template Post Type: page
 * @package web-prediksi
 * @since 1.0.0
 */

$providers = [
    'pp'  => [ 'name' => 'PP',  'link' => 'Pragmatic' ],
    'idn' => [ 'name' => 'IDN', 'link' => 'IDNSlot' ],
    'pg'  => [ 'name' => 'PG',  'link' => 'PGSoft' ],
    'hb'  => [ 'name' => 'HB',  'link' => 'Habanero' ],
    'mg'  => [ 'name' => 'MG',  'link' => 'Microgaming' ],
    'isb' => [ 'name' => 'ISB', 'link' => 'Isoftbet' ],
];

get_header();

?>

<section>
    <div class="container text-white px-3 pt-5 pb-4">
        <div class="card card-list-provider bg-color-4 border-0 px-2 py-2 mb-3">
            <div class="card-body bg-color-2 border-0 px-1 pt-2 pb-0 pb-lg-2">
                <div class="row row-cols-lg-6 no-gutters justify-content-between align-items-center">
                    <?php foreach ( $providers as $provider ) : ?>
                        <div class="col-6 col-lg px-1">
                            <div class="card card-provider bg-gradient-green border-0 mb-2 mb-lg-0" data-game="<?php echo $provider['link']; ?>">
                                <div class="card-body border-0 px-2 py-2">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col-auto">
                                            <div class="provider-thumbnail bg-color-1">
                                                <img src="<?php echo site_url() . '/assets/' . strtolower( $provider['name'] ) . '.svg'; ?>">
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <p class="card-title text-white text-center text-uppercase ml-2 mb-0">
                                                <small class="font-weight-bold"><?php echo $provider['link']; ?></small>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <div id="list-game-slot" class="game-wrapper">
            <h3 class="text-center mt-3 mb-0">
                <span><i class="fa fa-spin fa-spinner"></i>&ensp;Loading...</span>
            </h3>
        </div>
    </div>
</section>

<script type="text/javascript">
    function loadGame(provider) {
        $.ajax({
            type     : 'POST',
            url      : '<?php bloginfo('wpurl'); ?>/wp-admin/admin-ajax.php',
            data     : { 'action' : 'rtp', 'provider' : provider },
            success  : function (result) {
                $('#list-game-slot').html(result);
            }
        });
    }
    
    $(document).ready(function() {
        loadGame('Pragmatic');

        $('.card.card-provider').on('click', function() {
            var dataGame = $(this).attr('data-game');

            $('#list-game-slot').html('<h3 class="text-center mt-3 mb-0"><span><i class="fa fa-spin fa-spinner"></i>&ensp;Loading...</span></h3>');

            loadGame(dataGame);
        });
    });
</script>

<?php

get_footer();
