<?php
/**
 * Template Name: Data Result
 * Template Post Type: page
 * @package web-prediksi
 * @since 1.0.0
 */

$history = $exito->get_history( get_post_meta( get_the_ID(), 'link-scrape', true ) );

get_header();

?>

<section class="page-header pt-1 pt-lg-2">
    <div class="container-fluid px-0 pt-4 pb-2">
		<h3 class="page-title d-none d-lg-block text-white text-center text-uppercase">
            <span><?php echo get_the_title(); ?></span>
		</h3>
		<h5 class="page-title d-block d-lg-none text-white text-center text-uppercase">
            <span><?php echo get_the_title(); ?></span>
		</h5>
    </div>
</section>

<section>
    <div class="container px-3 py-3">
        <div class="card card-content shadow bg-gradient-green border-0 px-2 py-2 mb-3 mb-lg-4">
            <div class="card-body bg-color-1 border-0 px-0 py-0">
                <table class="table table-borderless table-striped bg-color-2 text-white text-center mb-0">
                    <thead>
                        <tr>
                            <th class="d-none d-lg-table-cell">Periode</th>
                            <th class="d-none d-lg-table-cell">Hari</th>
                            <th>Tanggal</th>
                            <th>Result</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ( $history as $data ) : ?>
                            <tr>
                                <td class="d-none d-lg-table-cell"><?php echo $data['periode']; ?></td>
                                <td class="d-none d-lg-table-cell"><?php echo $data['hari']; ?></td>
                                <td><?php echo $data['tanggal']; ?></td>
                                <td>
                                    <div class="result-number">
                                        <?php
                                            $numbers = str_split( $data['result'] );
                                            foreach ( $numbers as $digit ) {
                                                echo '<div class="d-inline-block digit">' . $digit . '</div>';
                                            }
                                        ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>

<?php if ( have_posts() ) : while ( have_posts() ) : ?>
    <section class="content-wrapper bg-color-2">
        <div class="container px-3 py-3 py-lg-4">
            <div class="content content-home text-white mt-3 px-3 py-3">
                <?php the_post(); the_content(); ?>
            </div>
        </div>
    </section>
<?php endwhile; endif; ?>

<?php

get_footer();
