<?php
/**
 * Template Name: Paito
 * Template Post Type: page
 * @package web-prediksi
 * @since 1.0.0
 */

$halaman = get_pages([ 'post_type' => 'page', 'meta_key' => '_wp_page_template', 'meta_value' => 'page-paito-iframe.php' ]);
$iframe  = get_the_permalink( $halaman[0]->ID );
$pasaran = get_post_meta( get_the_ID(), 'link-scrape', true );

get_header();

?>

<section class="page-header pt-1 pt-lg-2">
    <div class="container px-0 pt-4 pb-2">
		<h3 class="page-title d-none d-lg-block text-white text-center text-uppercase">
            <span><?php echo get_the_title(); ?></span>
		</h3>
		<h5 class="page-title d-block d-lg-none text-white text-center text-uppercase">
            <span><?php echo get_the_title(); ?></span>
		</h5>
    </div>
</section>

<section>
    <div class="container px-3 py-3">
        <div class="card card-content shadow bg-gradient-green border-0 px-2 py-2 mb-3 mb-lg-4">
            <div class="card-body bg-color-3 border-0 px-0 py-0">
                <iframe class="d-block w-100 mb-0" src="<?php echo $iframe . '?use-iframe=yes&pasaran=' . $pasaran; ?>" frameborder="0" height="550px"></iframe>
            </div>
        </div>
    </div>
</section>

<?php if ( have_posts() ) : while ( have_posts() ) : ?>
    <section class="content-wrapper bg-color-2">
        <div class="container px-3 py-3 py-lg-4">
            <div class="content content-home text-white mt-3 px-3 py-3">
                <?php the_post(); the_content(); ?>
                <hr class="my-3 border-light">
                <div class="tags-wrapper">
                    <p class="text-white text-left mb-1">Tags :</p>
                    <?php if ( !empty( get_the_tags() ) ) : foreach ( get_the_tags() as $tag ) : ?>
                        <a href="<?php echo get_tag_link( $tag->term_id ); ?>" class="badge badge-dark text-white font-weight-normal px-2 py-2 mb-0 mt-1"><?php echo $tag->name; ?></a>
                    <?php endforeach; endif; ?>
                </div>
            </div>
        </div>
    </section>
<?php endwhile; endif; ?>

<?php

get_footer();
