<?php
/**
 * Template Name: Livedraw - iFrame
 * Template Post Type: page
 * @package web-prediksi
 * @since 1.0.0
 */

$pasaran = ( isset( $_GET['pasaran'] ) ? $_GET['pasaran'] : 'hongkong' );

?>

<!DOCTYPE HTML>
<html>
    <head>
        <!-- wp_head -->
        <?php wp_head(); ?>
        <!-- meta -->
        <meta charset="<?php echo get_bloginfo('charset'); ?>">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
        <meta name="description" content="<?php echo get_bloginfo('description'); ?>">
        <!-- link -->
        <link rel="shortcut icon" href="<?php echo get_site_icon_url(); ?>">
        <!-- style -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/color.css">
        <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/livedraw.css">
        <!-- script -->
        <script src="https://cdn.jsdelivr.net/npm/jquery@3.2.1/dist/jquery.min.js"></script>
        <script src="<?php echo get_template_directory_uri(); ?>/assets/js/clock.js"></script>
    </head>

    <body>
        <?php
            $file_path = get_template_directory() . '/templates/livedraw-' . $pasaran . '.php';

            set_query_var( 'web_data', $exito->get_livedraw( $pasaran ) );
            set_query_var( 'text_ads', get_post_meta( get_the_ID(), 'text-ads', true ) );

            if ( file_exists( $file_path ) ) {
                get_template_part( 'templates/livedraw', $pasaran );
            } else {
                get_template_part( 'templates/livedraw', 'default' );
            }
        ?>
        <div class="container-fluid px-3 py-3 py-lg-4">
            <div class="row no-gutters">
                <div class="col-12">
                    <div class="card card-iframe bg-color-1 shadow border-0">
                        <div class="card-header bg-color-2 x-3 py-3">
                            <h5 class="text-gold text-center font-weight-bold mb-0">
                                <span>Iframe Widget Code</span>
                            </h5>
                        </div>
                        <div class="card-body text-white px-3 py-3">
                            <p class="text-white text-center mb-0">
                                <span>&lt;iframe src="<?php echo get_permalink( get_the_ID() ) . '?use-iframe=yes&pasaran=' . $pasaran; ?>" frameborder="0" style="width: 100%;"&gt;&lt;/iframe&gt;</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
