<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

global $paged;

if (get_query_var( 'paged' )) {
	$paged = get_query_var( 'paged' );
} elseif (get_query_var( 'page' )) {
	$paged = get_query_var( 'page' );
} else {
	$paged = '1';
}

get_header();

?>

<section class="page-header pt-1 pt-lg-2">
    <div class="container-fluid px-0 py-4">
		<h3 class="page-title d-none d-lg-block text-white text-center text-uppercase">
            <span><?php echo ucwords( str_replace( '-', ' ', get_query_var( 'category_name' ) ) ); ?></span>
		</h3>
		<h5 class="page-title d-block d-lg-none text-white text-center text-uppercase">
            <span><?php echo ucwords( str_replace( '-', ' ', get_query_var( 'category_name' ) ) ); ?></span>
		</h5>
    </div>
</section>

<section class="bg-color-1">
    <div class="container px-3 pt-1 pb-3">
        <?php if ( have_posts() ) : ?>
            <div class="row no-gutters">
                <?php while ( have_posts() ) : the_post(); ?>
                    <div class="col-12 col-lg-4 d-flex px-2">
                        <?php
                            set_query_var( 'post_id', get_the_ID() );
                            get_template_part( 'components/part-card', 'post' );
                        ?>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php endif; ?>
        <div class="row no-gutters my-3 px-2">
            <div class="col-6 text-left">
                <?php next_posts_link( '← Sebelumnya' ); ?>
            </div>
            <div class="col-6 text-right">
                <?php previous_posts_link( 'Selanjutnya →' ); ?>
            </div>
        </div>
    </div>
</section>

<?php

get_footer();
