<?php
/**
 * @package web-result
 * @since 1.0.0
 */

function get_paito( $page = 'hongkong' ) {
    switch ( $page ) {
        case 'benin-pools' :
            $link = 'https://paitowarnatogel.com/paito/paitotable.php?status=BENIN';
        break;
        case 'bullseye' :
            $link = 'http://128.199.199.139/paito-warna-bullseye/';
        break;
        case 'california' :
            $link = 'http://live.webpaito.com/paito-warna/california/';
        break;
        case 'canadia-pools' :
            $link = 'https://tabeldata.xyz/paito-warna-canadia/';
        break;
        case 'carolina-day' :
            $link = 'http://128.199.199.139/paito-warna-north-carolina-day/';
        break;
        case 'carolina-evening' :
            $link = 'http://128.199.199.139/paito-warna-north-carolina-evening/';
        break;
        case 'china-night' :
            $link = 'https://chinapoolsnight.com/paito/?key='.md5('SuksesTeam100%');
        break;
        case 'china-pools' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=CHINA%20POOLS';
        break;
        case 'chonburi-pools' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=CHONBURI%20POOLS';
        break;
        case 'dewata-pools' :
            $link = 'https://paitowarnatogel.com/paito/paitotable.php?status=DEWATA';
        break;
        case 'eibar-pools' :
            $link = 'https://paitowarnatogel.com/paito/paitotable.php?status=EIBAR';
        break;
        case 'eropa-lotto' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=EROPA%20LOTTO';
        break;
        case 'espanol-pools' :
            $link = 'https://espanolpools.com/history-result/?paito=pool_day';
        break;
        case 'florida-evening' :
            $link = 'http://128.199.199.139/paito-warna-florida-evening/';
        break;
        case 'florida-midday' :
            $link = 'http://128.199.199.139/paito-warna-florida-midday/';
        break;
        case 'grenada-lottery' :
            $link = 'https://grenadalottrey.com/history-result/?paito=pool_day';
        break;
        case 'hebei-pools' :
            $link = 'https://paitowarnatogel.com/paito/paitotable.php?status=HEBEI';
        break;
        case 'hongkong' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=HONGKONG';
        break;
        case 'jakarta-pools' :
            $link = 'http://45.76.178.21/paito-warna-jakarta/';
        break;
        case 'japan-even' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=JAPAN%20EVEN';
        break;
        case 'japan-pools' :
            $link = 'https://178.128.222.83/iframe-paito/?pasaran=japan-pools';
        break;
        case 'jowo-pools-09' :
            $link = 'https://prediksiku.org/paito-warna-jowo-pools-09-00-wib/';
        break;
        case 'jowo-pools-21' :
            $link = 'https://prediksiku.org/paito-warna-jowo-pools-21-00-wib/';
        break;
        case 'juventus-pools' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=JUVENTUS%20POOLS';
        break;
        case 'kentucky-evening' :
            $link = 'http://128.199.199.139/paito-warna-kentucky-evening/';
        break;
        case 'kentucky-midday' :
            $link = 'http://128.199.199.139/paito-warna-kentucky-midday/';
        break;
        case 'kupang-lotto' :
            $link = 'https://kupanglotto.com/history-result/?paito=pool_day';
        break;
        case 'magnum-4d' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=MAGNUM%204D';
        break;
        case 'magnum-cambodia' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=CAMBODIA';
        break;
        case 'magnum-pools' :
            $link = 'http://datapengeluaran.ws/paito-warna-magnum4d/';
        break;
        case 'millwall-pools' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=MILLWALL';
        break;
        case 'morocco-quatro-01' :
            $link = 'http://paitowarna4dp.net/paito-warna-morocco-quatro-01/';
        break;
        case 'morocco-quatro-04' :
            $link = 'http://paitowarna4dp.net/paito-warna-morocco-quatro-04/';
        break;
        case 'morocco-quatro-19' :
            $link = 'http://paitowarna4dp.net/paito-warna-morocco-quatro-19/';
        break;
        case 'morocco-quatro-22' :
            $link = 'http://paitowarna4dp.net/paito-warna-morocco-quatro-22/';
        break;
        case 'new-york-midday' :
            $link = 'https://datapaitowarna.com/paito-warna-new-york-midday/';
        break;
        case 'new-york-evening' :
            $link = 'http://128.199.199.139/paito-warna-new-york-evening/';
        break;
        case 'north-carolina-day' :
            $link = 'http://paitowarna4dp.net/paito-warna-north-carolina-day/';
        break;
        case 'north-carolina-evening' :
            $link = 'http://paitowarna4dp.net/paito-warna-north-carolina-evening/';
        break;
        case 'oregon-03' :
            $link = 'http://128.199.199.139/paito-warna-oregon-04/';
        break;
        case 'oregon-04' :
            $link = 'http://128.199.199.139/paito-warna-oregon-04/';
        break;
        case 'oregon-06' :
            $link = 'http://128.199.199.139/paito-warna-oregon-07/';
        break;
        case 'oregon-07' :
            $link = 'http://128.199.199.139/paito-warna-oregon-07/';
        break;
        case 'oregon-09' :
            $link = 'http://128.199.199.139/paito-warna-oregon-10/';
        break;
        case 'oregon-10' :
            $link = 'http://128.199.199.139/paito-warna-oregon-10/';
        break;
        case 'oregon-12' :
            $link = 'http://128.199.199.139/paito-warna-oregon-13/';
        break;
        case 'oregon-13' :
            $link = 'http://128.199.199.139/paito-warna-oregon-13/';
        break;
        case 'orlando-day' :
            $link = 'http://178.128.17.140/paito-warna-orlando-day-4d-harian-lengkap/';
        break;
        case 'orlando-evening' :
            $link = 'http://178.128.17.140/paito-warna-orlando-evening-4d-harian-lengkap/';
        break;
        case 'orlando-midday' :
            $link = 'http://178.128.17.140/paito-warna-orlando-midday-4d-harian-lengkap/';
        break;
        case 'pcso' :
            $link = 'http://128.199.199.139/paito-warna-pcso/';
        break;
        case 'saigon-lotto' :
            $link = 'https://paitokamboja.com/paito-warna-saigon-lotto/';
        break;
        case 'sg-45-toto' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=SG45%20TOTO';
        break;
        case 'singapore-night' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=SINGAPORE%20NIGHT';
        break;
        case 'singapore' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=SINGAPORE';
        break;
        case 'sydney-night' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=SYDNEY%20NIGHT';
        break;
        case 'sydney' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=SYDNEY';
        break;
        case 'taiwan-lotto' :
            $link = 'http://128.199.199.139/paito-warna-taiwan/';
        break;
        case 'taiwan-pools' :
            $link = 'http://128.199.199.139/paito-warna-taiwan/';
        break;
        case 'toshima-pools' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=TOSHIMA%20POOLS';
        break;
        case 'toto-macau' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=TOTOMACAU';
        break;
        case 'toto-macau-1' :
            $link = 'https://gurutoto.net/paito-warna-gurutoto/paito-warna-toto-macau-1300/';
        break;
        case 'toto-macau-2' :
            $link = 'https://gurutoto.net/paito-warna-gurutoto/paito-warna-toto-macau-1600/';
        break;
        case 'toto-macau-3' :
            $link = 'https://gurutoto.net/paito-warna-gurutoto/paito-warna-toto-macau-1900/';
        break;
        case 'toto-macau-4' :
            $link = 'https://gurutoto.net/paito-warna-gurutoto/paito-warna-toto-macau-2200/';
        break;
        case 'vietnam-lottery' :
            $link = 'https://vietnamlottery.online/history-result/?paito=pool_day';
        break;
        case 'virginia-day' :
            $link = 'http://paitowarna4dp.net/paito-warna-virginia-day/';
        break;
        case 'virginia-night' :
            $link = 'http://paitowarna4dp.net/paito-warna-virginia-night/';
        break;
        case 'watford-pools' :
            $link = 'http://47.242.0.57/site/paito/paitotable.php?status=WATFORD%20POOLS';
        break;

        default :
            $link = 'https://kode.syairguccimas.today/paito-warna-hongkong/';
        break;
    }

    return scrape_paito( $link );
}

function scrape_paito( $link = '' ) {
    ini_set("user_agent", "Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0");
    
    $html = file_get_html( $link );
    $data = $html->find( 'table[id="drawing-table"]', 0 );

    foreach ( $data->find( 'tr', 0 )->find( 'td' ) as $top ) {
        $top->class = 'top';
    }

    foreach ( $data->find( 'td' ) as $td ) {
        if ( $td->class == 'jppro' || $td->class == 'pto' || $td->class == 'reside' || $td->class == 'text-center ke' ) {
            $td->class = 'asu';
        } elseif ( $td->class == 'jpro' || $td->class == 'ptox' || $td->class == 'residex' || $td->class == 'text-center jml' ) {
            $td->class = 'asux';
        }
    }
    
    return [ 'is_top' => false, 'data' => $data->outertext ];
}