<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

define( 'TXTDOMAIN', 'web-prediksi' );

require_once get_stylesheet_directory() . '/includes/class-bootstrap-navwalker.php';
require_once get_stylesheet_directory() . '/includes/class-simple-html-dom.php';
require_once get_stylesheet_directory() . '/includes/class-exito-post.php';
require_once get_stylesheet_directory() . '/includes/class-exito-system.php';
require_once get_stylesheet_directory() . '/includes/class-exito.php';
require_once get_stylesheet_directory() . '/includes/inc-paito.php';

global $exito;
$exito = new Exito();
$exito->run();

function web_logo( $class = null ) {
    global $exito;
    return $exito->web_logo( $class );
}

function web_copyright( $date = '2000' ) {
    return __( 'Copyright', TXTDOMAIN ) . ' &copy; ' . date( 'Y' ) . ' <a class="site-url" href="/">' . get_bloginfo( 'name' ) . '</a>, All Rights Reserved.';
}

function format_prize($data = [], $load = '') {
    if (isset($data['tanggal'])) {
        $data['tanggal'] = ( $data['tanggal'] == '' ) ? date( 'd M Y' ) : $data['tanggal'];
    }
    if (isset($data['prize_1'])) {
        $data['prize_1'] = is_numeric($data['prize_1']) ? $data['prize_1'] : $load;
    }
    if (isset($data['prize_2'])) {
        $data['prize_2'] = is_numeric($data['prize_2']) ? $data['prize_2'] : $load;
    }
    if (isset($data['prize_3'])) {
        $data['prize_3'] = is_numeric($data['prize_3']) ? $data['prize_3'] : $load;
    }

    if (isset($data['prize_4'])) {
        if (is_array($data['prize_4'])) :
            foreach ($data['prize_4'] as $key4 => $val4) {
                $data['prize_4'][$key4] = (is_numeric($val4) ? $val4 : $load);
            }
        else :
            $data['prize_4'] = is_numeric($data['prize_4']) ? $data['prize_4'] : $load;
        endif;
    }
    if (isset($data['prize_5'])) {
        if (is_array($data['prize_5'])) :
            foreach ($data['prize_5'] as $key5 => $val5) {
                $data['prize_5'][$key5] = (is_numeric($val5) ? $val5 : $load);
            }
        else :
            $data['prize_5'] = is_numeric($data['prize_5']) ? $data['prize_5'] : $load;
        endif;
    }
    if (isset($data['prize_6'])) {
        if (is_array($data['prize_6'])) :
            foreach ($data['prize_6'] as $key6 => $val6) {
                $data['prize_6'][$key6] = (is_numeric($val6) ? $val6 : $load);
            }
        else :
            $data['prize_6'] = is_numeric($data['prize_6']) ? $data['prize_6'] : $load;
        endif;
    }
    if (isset($data['prize_7'])) {
        if (is_array($data['prize_7'])) :
            foreach ($data['prize_7'] as $key7 => $val7) {
                $data['prize_7'][$key7] = (is_numeric($val7) ? $val7 : $load);
            }
        else :
            $data['prize_7'] = is_numeric($data['prize_7']) ? $data['prize_7'] : $load;
        endif;
    }

    return $data;
}

function sc_tanggal() {
    return date_i18n( 'd F Y', strtotime( '+1days' ) );
}
add_shortcode('tanggal', 'sc_tanggal');

function sc_banner() {
    $html = '';
    if (is_active_sidebar('prediksi_banner')) :
        ob_start();
        dynamic_sidebar('prediksi_banner');
        $banner = ob_get_contents();
        ob_get_clean();

        $html .= '<div class="content-banner my-3">';
        $html .= '    <div class="row no-gutters">';
        $html .= '        <div class="col-12">' . $banner . '</div>';
        $html .= '    </div>';
        $html .= '</div>';
    endif;
    return $html;
}
add_shortcode('banner', 'sc_banner');

function sc_data_result() {
    ob_start();
    
    get_template_part( 'components/part-card', 'data-result' );

    $output = ob_get_contents();

    ob_get_clean();

    return $output;
}
add_shortcode('data_result', 'sc_data_result');

function sc_livedraw() {
    ob_start();
    
    get_template_part( 'components/part-card', 'livedraw' );

    $output = ob_get_contents();

    ob_get_clean();

    return $output;
}
add_shortcode('livedraw', 'sc_livedraw');

function sc_paito() {
    ob_start();
    
    get_template_part( 'components/part-card', 'paito' );

    $output = ob_get_contents();

    ob_get_clean();

    return $output;
}
add_shortcode('paito', 'sc_paito');

function get_buku_mimpi() {
    $curl = curl_init();
    curl_setopt_array( $curl, [
        CURLOPT_URL            => 'https://128.199.105.5/bukumimpi.php',
        CURLOPT_COOKIE         => 'PHPSESSID=gv0cpgujm5t809hi64dg1u7pf2;',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_SSL_VERIFYPEER => false,
    ] );
    session_write_close();
    $data = curl_exec( $curl );
    curl_close( $curl );

    $numb = 1;
    $html = str_get_html( $data )->find( 'div[class="bukumimpi-table"]', 0 )->find( 'table', 0 )->find( 'tbody', 0 );
    $list = [];

    foreach ( $html->find( 'tr' ) as $data ) {
        $list[] = [
            'numb' => $numb,
            'keterangan' => trim( $data->find( 'td', 1 )->plaintext ),
            'jenis_game' => trim( $data->find( 'td', 2 )->plaintext ),
            'nomor' => trim( $data->find( 'td', 3 )->plaintext ),
        ];
        $numb++;
    }

    return $list;
}

function sc_buku_mimpi() {
    $list  = get_buku_mimpi();
    $html  = '';

    $html .= '<div class="form-row my-2">';
    $html .= '    <div class="col-12 col-lg-auto">';
    $html .= '        <select class="form-control" id="jenis-game">';
    $html .= '            <option value="all">Semua Jenis Game</option>';
    $html .= '            <option value="2D">2D</option>';
    $html .= '            <option value="3D">3D</option>';
    $html .= '            <option value="4D">4D</option>';
    $html .= '        </select>';
    $html .= '    </div>';
    $html .= '    <div class="col-12 col-lg-auto">';
    $html .= '        <select class="form-control" id="order">';
    $html .= '            <option value="all">Semua Data</option>';
    $html .= '            <option value="nomor">Nomor</option>';
    $html .= '            <option value="keterangan">Keterangan</option>';
    $html .= '        </select>';
    $html .= '    </div>';
    $html .= '    <div class="col-12 col-lg-auto">';
    $html .= '        <input type="text" class="form-control" id="order" placeholder="ketik nomor atau keterangan">';
    $html .= '    </div>';
    $html .= '    <div class="col-12 col-lg-auto">';
    $html .= '        <button class="btn btn-search btn-warning"><i class="fa fa-search"></i>&ensp;Cari</button>';
    $html .= '    </div>';
    $html .= '</div>';

    $html .= '<table class="table table-sm table-borderless table-datatable bg-white my-3">';
    $html .= '<thead class="text-white bg-color-1">';
    $html .= '  <tr>';
    $html .= '      <th class="text-center py-lg-3">No</th>';
    $html .= '      <th class="py-lg-3">Keterangan</th>';
    $html .= '      <th class="py-lg-3">Jenis Game</th>';
    $html .= '      <th class="py-lg-3">Nomor</th>';
    $html .= '  </tr>';
    $html .= '</thead>';
    $html .= '<tbody>';

    foreach ( $list as $data ) :
        $html .= '<tr>';
        $html .= '  <td class="text-center">' . $data['numb'] . '</td>';
        $html .= '  <td class="keterangan">' . $data['keterangan'] . '</td>';
        $html .= '  <td class="' . $data['jenis_game'] . '">' . $data['jenis_game'] . '</td>';
        $html .= '  <td class="nomor">' . $data['nomor'] . '</td>';
        $html .= '</tr>';
    endforeach;

    $html .= '</tbody>';
    $html .= '</table>';

    return $html;
}
add_shortcode('buku_mimpi', 'sc_buku_mimpi');
