<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */
?>

<!-- component header -->
<section>
    <div class="container-fluid px-0 py-0 py-lg-3">
        <div class="logo-wrapper px-3 py-3">
            <a href="<?php echo site_url(); ?>"><?php echo web_logo(); ?></a>
        </div>
    </div>
</section>

<?php if ( is_active_sidebar( 'header_banner' ) ) : ?>
    <section>
        <div class="container-fluid px-0 py-0">
            <div class="header-banner">
                <div class="row no-gutters">
                    <?php dynamic_sidebar( 'header_banner' ); ?>
                </div>
            </div>
        </div>
    </section>

<?php endif; ?>

<header class="shadow bg-color-2">
    <div class="container-fluid px-0 py-0">
        <nav class="navbar navbar-expand-lg navbar-dark px-3 py-4">
            <div class="navbar-collapse text-center mt-0">
                <?php
                    wp_nav_menu([
                        'depth'          => 2,
                        'theme_location' => 'menu_header',
                        'container'      => false,
                        'items_wrap'     => '<ul class="navbar-nav ml-auto mr-auto">%3$s</ul>',
                        'fallback_cb'    => 'WP_Bootstrap_Navwalker::fallback',
                        'walker'         => new WP_Bootstrap_Navwalker(),
                    ]);
                ?>
            </div>
        </nav>
    </div>
</header>

